/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema.facets;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsVariable;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.Facet;

public class CardinalityFacet
implements Facet {
    private int cardMin;
    private int cardMax;

    public CardinalityFacet(int cardMin, int cardMax) {
        this.cardMin = cardMin;
        this.cardMax = cardMax;
    }

    public void validate(AbsObject value, Ontology onto) throws OntologyException {
        if (value instanceof AbsVariable) {
            return;
        }
        if (!(value instanceof AbsAggregate)) {
            throw new OntologyException(value + " is not an AbsAggregate");
        }
        int size = ((AbsAggregate)value).size();
        if (size < this.cardMin) {
            throw new OntologyException(value + " includes less elements than required (" + this.cardMin + ")");
        }
        if (this.cardMax != -1 && size > this.cardMax) {
            throw new OntologyException(value + " includes more elements than allowed (" + this.cardMax + ")");
        }
    }
}

